/*
 * Decompiled with CFR 0.152.
 */
package com.android.dpbridge.utils;

import com.android.dpbridge.utils.JavaVersion;

public class SystemUtils {
    public static final String JAVA_SPECIFICATION_VERSION = SystemUtils.getSystemProperty();
    private static final JavaVersion JAVA_SPECIFICATION_VERSION_AS_ENUM = JavaVersion.get();

    public static boolean isJavaVersionAtLeast(JavaVersion requiredVersion) {
        if (JAVA_SPECIFICATION_VERSION_AS_ENUM != null) {
            return JAVA_SPECIFICATION_VERSION_AS_ENUM.atLeast(requiredVersion);
        }
        return false;
    }

    private static String getSystemProperty() {
        try {
            return System.getProperty("java.specification.version");
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property 'java.specification.version'; the SystemUtils property value will default to null.");
            return null;
        }
    }
}

