/*
 * Decompiled with CFR 0.152.
 */
package com.android.dpbridge.utils;

import androidx.annotation.NonNull;
import com.android.dpbridge.utils.SystemUtils;

public enum JavaVersion {
    JAVA_0_9(1.5f, "0.9"),
    JAVA_1_1(1.1f, "1.1"),
    JAVA_1_2(1.2f, "1.2"),
    JAVA_1_3(1.3f, "1.3"),
    JAVA_1_4(1.4f, "1.4"),
    JAVA_1_5(1.5f, "1.5"),
    JAVA_1_6(1.6f, "1.6"),
    JAVA_1_7(1.7f, "1.7"),
    JAVA_1_8(1.8f, "1.8");

    private final float value;
    private final String name;

    private JavaVersion(float value, String name) {
        this.value = value;
        this.name = name;
    }

    public boolean atLeast(JavaVersion requiredVersion) {
        return this.value >= requiredVersion.value;
    }

    static JavaVersion get() {
        if ("0.9".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_0_9;
        }
        if ("1.1".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_1;
        }
        if ("1.2".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_2;
        }
        if ("1.3".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_3;
        }
        if ("1.4".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_4;
        }
        if ("1.5".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_5;
        }
        if ("1.6".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_6;
        }
        if ("1.7".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_7;
        }
        if ("1.8".equals(SystemUtils.JAVA_SPECIFICATION_VERSION)) {
            return JAVA_1_8;
        }
        return null;
    }

    @NonNull
    public String toString() {
        return this.name;
    }
}

