/*
 * Decompiled with CFR 0.152.
 */
package com.android.dpbridge;

import android.annotation.SuppressLint;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import com.android.dpbridge.ILSPLoadPackage;
import com.android.dpbridge.IXposedMod;
import com.android.dpbridge.LSPBridge;
import com.android.dpbridge.LSPHelpers;
import com.android.dpbridge.callbacks.XC_LoadPackage;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@SuppressLint(value={"PrivateApi", "unused"})
public final class LSPInit {
    private static final String TAG = "LSPlant-XposedBridge";
    private static final String INSTANT_RUN_CLASS = "com.android.tools.fd.runtime.BootstrapApplication";

    private LSPInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadModule(String apk, ClassLoader topClassLoader) {
        InputStream is;
        DexFile dexFile;
        Log.i((String)TAG, (String)("Loading modules from " + apk));
        if (!new File(apk).exists()) {
            Log.e((String)TAG, (String)"  File does not exist");
            return;
        }
        try {
            dexFile = new DexFile(apk);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"  Cannot load module", (Throwable)e);
            return;
        }
        if (dexFile.loadClass(INSTANT_RUN_CLASS, topClassLoader) != null) {
            Log.e((String)TAG, (String)"  Cannot load module, please disable \"Instant Run\" in Android Studio.");
            LSPHelpers.closeSilently(dexFile);
            return;
        }
        if (dexFile.loadClass(LSPBridge.class.getName(), topClassLoader) != null) {
            Log.e((String)TAG, (String)"  Cannot load module:");
            Log.e((String)TAG, (String)"  The Xposed API classes are compiled into the module's APK.");
            Log.e((String)TAG, (String)"  This may cause strange issues and must be fixed by the module developer.");
            Log.e((String)TAG, (String)"  For details, see: http://api.xposed.info/using.html");
            LSPHelpers.closeSilently(dexFile);
            return;
        }
        LSPHelpers.closeSilently(dexFile);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(apk);
            ZipEntry zipEntry = zipFile.getEntry("assets/xposed_init");
            if (zipEntry == null) {
                Log.e((String)TAG, (String)"  assets/xposed_init not found in the APK");
                LSPHelpers.closeSilently(zipFile);
                return;
            }
            is = zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"  Cannot read assets/xposed_init in the APK", (Throwable)e);
            LSPHelpers.closeSilently(zipFile);
            return;
        }
        PathClassLoader mcl = new PathClassLoader(apk, LSPBridge.BOOTCLASSLOADER);
        BufferedReader moduleClassesReader = new BufferedReader(new InputStreamReader(is));
        try {
            String moduleClassName;
            while ((moduleClassName = moduleClassesReader.readLine()) != null) {
                if ((moduleClassName = moduleClassName.trim()).isEmpty() || moduleClassName.startsWith("#")) continue;
                try {
                    Log.i((String)TAG, (String)("  Loading class " + moduleClassName));
                    Class<?> moduleClass = mcl.loadClass(moduleClassName);
                    if (!IXposedMod.class.isAssignableFrom(moduleClass)) {
                        Log.e((String)TAG, (String)"    This class doesn't implement any sub-interface of IXposedMod, skipping it");
                        continue;
                    }
                    Object moduleInstance = moduleClass.newInstance();
                    if (!(moduleInstance instanceof ILSPLoadPackage)) continue;
                    LSPBridge.hookLoadPackage(new ILSPLoadPackage.Wrapper((ILSPLoadPackage)moduleInstance));
                }
                catch (Throwable t) {
                    Log.e((String)TAG, (String)("    Failed to load class " + moduleClassName), (Throwable)t);
                }
            }
            return;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("  Failed to load module from " + apk), (Throwable)e);
            return;
        }
        finally {
            LSPHelpers.closeSilently(is);
            LSPHelpers.closeSilently(zipFile);
        }
    }

    public static void onPackageLoad(String packageName, String processName, ApplicationInfo appInfo, boolean isFirstApp, ClassLoader classLoader) {
        XC_LoadPackage.LoadPackageParam param = new XC_LoadPackage.LoadPackageParam(LSPBridge.sLoadedPackageCallbacks);
        param.packageName = packageName;
        param.processName = processName;
        param.appInfo = appInfo;
        param.isFirstApplication = isFirstApp;
        param.classLoader = classLoader;
        XC_LoadPackage.callAll(param);
    }

    public static void loadso(String name) {
        if (name.contains(".so")) {
            System.load(name);
        } else {
            System.loadLibrary(name);
        }
    }
}

