/*
 * Decompiled with CFR 0.152.
 */
package com.android.dpbridge;

import android.util.Log;
import com.android.dpbridge.LSP_MethodH;
import com.android.dpbridge.callbacks.XC_LoadPackage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class LSPBridge {
    public static final ClassLoader BOOTCLASSLOADER = ClassLoader.getSystemClassLoader();
    public static final String TAG = "LSPlant-XposedBridge";
    @Deprecated
    public static int XPOSED_BRIDGE_VERSION;
    private static final Object[] EMPTY_ARRAY;
    private static final Map<Member, CopyOnWriteSortedSet<LSP_MethodH>> sHookedMethodCallbacks;
    static final CopyOnWriteSortedSet<XC_LoadPackage> sLoadedPackageCallbacks;
    static final Map<Member, HookInfo> sHookRecords;

    private LSPBridge() {
    }

    public static int getXposedVersion() {
        return XPOSED_BRIDGE_VERSION;
    }

    public static synchronized void log(String text) {
        Log.i((String)TAG, (String)text);
    }

    public static synchronized void log(Throwable t) {
        Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LSP_MethodH.Unhook hookMethod(Member hookMethod, LSP_MethodH callback) {
        CopyOnWriteSortedSet<LSP_MethodH> callbacks;
        if (!(hookMethod instanceof Method) && !(hookMethod instanceof Constructor)) {
            throw new IllegalArgumentException("Only methods and constructors can be hooked: " + hookMethod.toString());
        }
        if (Modifier.isAbstract(hookMethod.getModifiers())) {
            throw new IllegalArgumentException("Cannot hook abstract methods: " + hookMethod);
        }
        Map<Member, CopyOnWriteSortedSet<LSP_MethodH>> map = sHookedMethodCallbacks;
        synchronized (map) {
            callbacks = sHookedMethodCallbacks.get(hookMethod);
            if (callbacks == null) {
                callbacks = new CopyOnWriteSortedSet();
                HookInfo hookInfo = new HookInfo(hookMethod, callbacks);
                try {
                    Method backup = LSPBridge.hook0(hookInfo, hookMethod, hookInfo.getClass().getDeclaredMethod("callback", Object[].class));
                    if (backup == null) {
                        return null;
                    }
                    hookInfo.backup = backup;
                }
                catch (NoSuchMethodException e) {
                    Log.e((String)TAG, (String)e.getMessage());
                }
                sHookedMethodCallbacks.put(hookMethod, callbacks);
                sHookRecords.put(hookMethod, hookInfo);
            }
        }
        callbacks.add(callback);
        LSP_MethodH lSP_MethodH = callback;
        Objects.requireNonNull(lSP_MethodH);
        return lSP_MethodH.new LSP_MethodH.Unhook(hookMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void unhookMethod(Member hookMethod, LSP_MethodH callback) {
        CopyOnWriteSortedSet<LSP_MethodH> callbacks;
        Map<Member, CopyOnWriteSortedSet<LSP_MethodH>> map = sHookedMethodCallbacks;
        synchronized (map) {
            callbacks = sHookedMethodCallbacks.get(hookMethod);
            if (callbacks == null) {
                return;
            }
        }
        callbacks.remove(callback);
    }

    public static Set<LSP_MethodH.Unhook> hookAllMethods(Class<?> hookClass, String methodName, LSP_MethodH callback) {
        HashSet<LSP_MethodH.Unhook> unhooks = new HashSet<LSP_MethodH.Unhook>();
        for (Method method : hookClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            unhooks.add(LSPBridge.hookMethod(method, callback));
        }
        return unhooks;
    }

    public static Set<LSP_MethodH.Unhook> hookAllConstructors(Class<?> hookClass, LSP_MethodH callback) {
        HashSet<LSP_MethodH.Unhook> unhooks = new HashSet<LSP_MethodH.Unhook>();
        for (Constructor<?> constructor : hookClass.getDeclaredConstructors()) {
            unhooks.add(LSPBridge.hookMethod(constructor, callback));
        }
        return unhooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hookLoadPackage(XC_LoadPackage callback) {
        CopyOnWriteSortedSet<XC_LoadPackage> copyOnWriteSortedSet = sLoadedPackageCallbacks;
        synchronized (copyOnWriteSortedSet) {
            sLoadedPackageCallbacks.add(callback);
        }
    }

    private static synchronized native Method hook0(Object var0, Member var1, Method var2);

    public static Object invokeOriginalMethod(Member method, Object thisObject, Object[] args) throws NullPointerException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        HookInfo hookInfo = sHookRecords.get(method);
        try {
            if (hookInfo != null) {
                return LSPBridge.invokeMethod(hookInfo.backup, thisObject, args);
            }
            if (method == null) {
                throw new NullPointerException("Method must not be null");
            }
            if (!(method instanceof Method) && !(method instanceof Constructor)) {
                throw new IllegalArgumentException("Method must be a Method or Constructor");
            }
            int modifiers = method.getModifiers();
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalArgumentException("Method must not be abstract");
            }
            return LSPBridge.invokeMethod(method, thisObject, args);
        }
        catch (InstantiationException ex) {
            Log.e((String)TAG, (String)ex.getMessage());
            return null;
        }
    }

    private static Object invokeMethod(Member member, Object thisObject, Object[] args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (member instanceof Method) {
            Method method = (Method)member;
            method.setAccessible(true);
            return method.invoke(thisObject, args);
        }
        Constructor constructor = (Constructor)member;
        constructor.setAccessible(true);
        return constructor.newInstance(args);
    }

    static {
        EMPTY_ARRAY = new Object[0];
        sHookedMethodCallbacks = new HashMap<Member, CopyOnWriteSortedSet<LSP_MethodH>>();
        sLoadedPackageCallbacks = new CopyOnWriteSortedSet();
        sHookRecords = new HashMap<Member, HookInfo>();
    }

    public static final class CopyOnWriteSortedSet<E> {
        private volatile transient Object[] elements = new Object[0];

        public synchronized boolean add(E e) {
            int index = this.indexOf(e);
            if (index >= 0) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length + 1];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            newElements[this.elements.length] = e;
            Arrays.sort(newElements);
            this.elements = newElements;
            return true;
        }

        public synchronized boolean remove(E e) {
            int index = this.indexOf(e);
            if (index == -1) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length - 1];
            System.arraycopy(this.elements, 0, newElements, 0, index);
            System.arraycopy(this.elements, index + 1, newElements, index, this.elements.length - index - 1);
            this.elements = newElements;
            return true;
        }

        private int indexOf(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
            return -1;
        }

        public Object[] getSnapshot() {
            return this.elements;
        }
    }

    public static final class HookInfo {
        CopyOnWriteSortedSet<LSP_MethodH> callbacks;
        Member backup;
        Member method;

        HookInfo(Member hookMethod, CopyOnWriteSortedSet<LSP_MethodH> callbacks) {
            this.method = hookMethod;
            this.callbacks = callbacks;
        }

        public Object callback(Object[] args) throws Throwable {
            LSP_MethodH.MethodHookParam param = new LSP_MethodH.MethodHookParam();
            param.method = this.method;
            boolean isStatic = Modifier.isStatic(this.method.getModifiers());
            if (isStatic) {
                param.thisObject = null;
                param.args = args;
            } else {
                param.thisObject = args[0];
                param.args = new Object[args.length - 1];
                System.arraycopy(args, 1, param.args, 0, args.length - 1);
            }
            Object[] hooks = this.callbacks.getSnapshot();
            int hookCount = hooks.length;
            if (hookCount == 0) {
                try {
                    return LSPBridge.invokeMethod(this.backup, param.thisObject, param.args);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)LSPBridge.TAG, (String)e.getMessage());
                }
            }
            int beforeIdx = 0;
            do {
                try {
                    ((LSP_MethodH)hooks[beforeIdx]).beforeHookedMethod(param);
                }
                catch (Throwable t) {
                    Log.e((String)LSPBridge.TAG, (String)t.getMessage());
                    param.setResult(null);
                    param.returnEarly = false;
                    continue;
                }
                if (!param.returnEarly) continue;
                ++beforeIdx;
                break;
            } while (++beforeIdx < hookCount);
            if (!param.returnEarly) {
                try {
                    param.setResult(LSPBridge.invokeMethod(this.backup, param.thisObject, param.args));
                }
                catch (InvocationTargetException e) {
                    param.setThrowable(e.getCause());
                }
            }
            int afterIdx = beforeIdx - 1;
            do {
                Object lastResult = param.getResult();
                Throwable lastThrowable = param.getThrowable();
                try {
                    ((LSP_MethodH)hooks[afterIdx]).afterHookedMethod(param);
                }
                catch (Throwable t) {
                    Log.e((String)LSPBridge.TAG, (String)t.getMessage());
                    if (lastThrowable == null) {
                        param.setResult(lastResult);
                        continue;
                    }
                    param.setThrowable(lastThrowable);
                }
            } while (--afterIdx >= 0);
            Object result = param.getResultOrThrowable();
            Class<?> returnType = null;
            if (this.method instanceof Method) {
                returnType = ((Method)this.method).getReturnType();
            }
            if (result instanceof Boolean) {
                result = (boolean)((Boolean)result);
            } else if (result instanceof Integer) {
                result = (int)((Integer)result);
            } else if (result instanceof Long) {
                result = (long)((Long)result);
            } else if (returnType != null) {
                result = returnType.cast(result);
            }
            return result;
        }
    }
}

